# Importation des modules nécessaires
import tkinter as tk
from tkinter import filedialog, messagebox
import mysql.connector
import subprocess
# Création de la fenêtre principale 
root = tk.Tk() 
root.title("Gestionnaire de base de donnée") 
root.option_add("*Font", "Helvetica 10 bold")
# Connexion à la base de données MySQL 
conn = mysql.connector.connect( host= "localhost" , user= "root" , password= "" , database= "lojuzo" ) 
# Création d'un curseur pour exécuter les requêtes SQL 
cursor = conn.cursor() 

# Fonction pour insérer une requête SQL dans la base de données 
def insert_query():
# Ouvrir le fichier
    file = filedialog.askopenfile(mode="r", filetypes=[("Fichiers SQL", "*.sql")])
    if not file:
        return
    query = file.read()
# Exécuter la requête SQL
    try:
        cursor.execute(query)
        conn.commit()
        messagebox.showinfo("Succès", "La requête a été insérée avec succès dans la base de données.")
    except:
        messagebox.showerror("Erreur", "La requête n'a pas pu être insérée dans la base de données.")
        
# Fonction pour ouvrir un fichier de requêtes SQL et afficher son contenu dans un widget Text 
def open_file():
# Ouvrir le fichier
    filename = filedialog.askopenfilename(title="Ouvrir un fichier", filetypes=[("Fichiers SQL", "*.sql")])
    if not filename:
        return
# Effacer le contenu précédent de la zone de texte
    text.delete("1.0", tk.END)
# Lire le contenu du fichier
    with open(filename, "r", encoding="utf-8") as file:
        content = file.read()
# Afficher le contenu dans la zone de texte
    text.insert(tk.END, content)
# Fonction pour interroger la base de données
def query_database():
# Lire la requête SQL à partir d'un fichier externe
    file = filedialog.askopenfile(mode="r", filetypes = [("Fichier SQL", "*.sql")])
    if not file:
        return
    query = file.read()
# Exécuter la requête SQL
    try:
        cursor.execute(query)
        records = cursor.fetchall()
# Effacer le contenu précédent de la zone de texte
        text.delete("1.0", tk.END)
# Afficher les résultats de la requête dans la zone de texte
        for row in records:
            text.insert(tk.END, str(row) + "\n")
    except:
        messagebox.showerror("Erreur", "La requête n'a pas pu être exécutée.")

# Fonction pour afficher le contenu de toutes les tables de la base de données, ainsi que les noms de leurs colonnes, dans une fenêtre sous forme de tableau
def display_tables_content_columns_window():
    # Exécuter une requête SQL pour récupérer les noms de toutes les tables de la base de données
    cursor.execute("SHOW TABLES")
    tables = cursor.fetchall()
    # Créer une fenêtre pour afficher les données
    window = tk.Toplevel(root)
    window.title("Contenu de toutes les tables de la base de données, avec les noms de leurs colonnes")
    # Parcourir toutes les tables et afficher leur nom, les noms de colonnes et les données dans une grille
    row_num = 0
    for table in tables:
        table_name = table[0]
        # Exécuter une requête SQL pour récupérer les noms de toutes les colonnes de la table
        cursor.execute(f"DESCRIBE {table_name}")
        columns = cursor.fetchall()
        column_names = []
        for column in columns:
            column_names.append(column[0])
        # Exécuter une requête SQL pour récupérer le contenu de la table
        cursor.execute(f"SELECT * FROM {table_name}")
        table_content = cursor.fetchall()
        # Créer une étiquette pour afficher le nom de la table
        table_name_label = tk.Label(window, text=f"Table : {table_name}")
        table_name_label.grid(row=row_num, column=0, sticky="w")
        # Créer une liste pour stocker les étiquettes de noms de colonnes
        column_name_labels = []
        # Ajouter les étiquettes de noms de colonnes à la grille
        col_num = 0
        for column_name in column_names:
            column_name_label = tk.Label(window, text=column_name, anchor="center", relief="groove", bd=2)
            column_name_label.grid(row=row_num+1, column=col_num, sticky="we")
            column_name_labels.append(column_name_label)
            col_num += 1
        # Ajouter les données à la grille
        row_num += 2
        for row in table_content:
            col_num = 0
            for cell in row:
                cell_label = tk.Label(window, text=str(cell), relief="groove", bd=1)
                cell_label.grid(row=row_num, column=col_num, sticky="wens", padx=1, pady=1)
                col_num += 1
            row_num += 1
        # Ajouter des étiquettes vides pour les bordures de la grille
        for col in range(col_num):
            bottom_label = tk.Label(window, text="", relief="groove", bd=1)
            bottom_label.grid(row=row_num, column=col, sticky="we", padx=1, pady=1)

        for row in range(row_num):
            right_label = tk.Label(window, text="", relief="groove", bd=1)
            right_label.grid(row=row, column=col_num, sticky="ns", padx=1, pady=1)

file_path = "./lojuzo_insert.py"

# Sert à executer un programme python avec des inputs
def execute_external_program_with_file_and_inputs():
    # Demander  l'utilisateur de fournir les entres
    user_input = tk.simpledialog.askstring("Entrees utilisateur", "Entrez le nom de la base de donnee et le nom du CSV(avec l'extention) ( les noms de la base et du csv doivent etre separes par des espaces) :")

    # Crer un nouveau processus pour excuter le programme externe
    process = subprocess.Popen(["python", file_path], stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

    # Envoyer les entres utilisateur au programme externe via stdin
    inputs = user_input.split()
    for input_value in inputs:
        process.stdin.write(input_value.encode("utf-8"))
        process.stdin.write(b"\n")
        process.stdin.flush()

    # Lire la sortie standard et la sortie d'erreur du programme externe
    output, error = process.communicate()
    
    # Afficher la sortie standard dans une bote de dialogue
    if output:
        tk.messagebox.showinfo("Sortie du programme externe", output.decode("iso-8859-1"))
    else:
        tk.messagebox.showinfo("Sortie du programme externe", "Pas de sortie standard")
    
    # Afficher la sortie d'erreur dans une bote de dialogue
    if error:
        tk.messagebox.showerror("Erreur du programme externe", error.decode("iso-8859-1"))
    else:
        tk.messagebox.showinfo("Erreur du programme externe", "Pas d'erreur detectee")

# Sert à écrire des requêtes dans la zone de texte puis à les insérer dans la base de donnée
def execute_sql_query():
    # Rcuprer la requte SQL depuis la zone de texte
    query = text.get("1.0", "end-1c")
    # Excuter la requte SQL
    cursor = conn.cursor()
    for statement in query.split(';'):
        if statement.strip() != '':
            cursor.execute(statement)
            conn.next_result()
    # Afficher une bote de dialogue pour confirmer l'excution de la requte
    confirm = tk.messagebox.askyesno("Confirmation", "Voulez-vous vraiment excuter cette requte ?\n\n" + query)

    if confirm:
        # Afficher le rsultat dans une bote de dialogue
        tk.messagebox.showinfo("Insertion requte", "La requte a bien t insre")
        # Supprimer la requte de la zone de texte
        text.delete("1.0", "end")
    else:
        tk.messagebox.showinfo("Annul", "L'excution de la requte a t annule.")
        
# Définir la fonction qui ouvre la deuxième interface
def open_second_interface():
    # Créer une nouvelle fenêtre pour la deuxième interface
    second_window = tk.Toplevel() 
    # Ajouter des boutons pour les fonctions
    tk.Button(second_window, text="Ouvrir un fichier", command=open_file).pack()
    tk.Button(second_window, text="Afficher le contenu des tables et des colonnes", command=display_tables_content_columns_window).pack()
    tk.Button(second_window, text="Interroger la base de donnees avec un fichier externe (Select)", command=query_database).pack()
    tk.Button(second_window, text="Inserer une requte dans la base de donnees avec un fichier externe (Insert into,...)", command=insert_query).pack()
    tk.Button(second_window, text="Inserer la requete ecrrite", command=execute_sql_query).pack()
    tk.Button(second_window, text="Utiliser le convertisseur de CSV pour ajouter des donnes ", command=execute_external_program_with_file_and_inputs).pack()
    execute_sql_file.button_sql_file = tk.Button(second_window, text="Inserer une requte dans la base de donnees avec un fichier externe (Insert into,...)", command=execute_sql_file)
def execute_sql_file():
    filename = filedialog.askopenfilename(initialdir="/", title="Select file",
                                          filetypes=(("SQL files", "*.sql"), ("all files", "*.*")))
    if filename:
        with open(filename, 'r') as sql_file:
            sql = sql_file.read()
            try:
                cursor.execute(sql)
                conn.commit() # ajout du commit ici
                tk.messagebox.showinfo("Succs", "Requte excute avec succs !")
            except mysql.connector.Error as err:
                tk.messagebox.showerror("Erreur", "Une erreur s'est produite lors de l'excution de la requte : \n{}".format(err))



# Définir le contenu de la première interface
tk.Button(root, text="Ouvrir le menu", command=open_second_interface).pack()
 # Widget Text pour afficher les résultats des requêtes et les messages d'erreur 
text = tk.Text(root, height= 30 , width= 120 ) 
text.insert(tk.END, "ecrivez une requete ici")
text.pack() 
    # Lancement de la boucle principale 
root.mainloop()
conn.close()